/*******************************************************************/
/***                                                             ***/
/***   EasyGuideMapsEngine_V0.3.5.js                             ***/
/***                                                             ***/
/***   Version   : V0.3.5                                        ***/
/***   Date      : 04.05.2018                                    ***/
/***   Author    : 3d-berlin vr solutions GmbH                   ***/
/***   Copyright : 2018 3d-berlin vr solutions GmbH              ***/
/***   Website   : www.3d-berlin.com                             ***/
/***                                                             ***/
/***    This library is owned by 3d-berlin vr solutions GmbH     ***/
/***        Do not copy or distribute without permission         ***/
/***                                                             ***/
/*******************************************************************/
interface IEasyGuideMapsEngineOptions {
    "debug"?: boolean;
    "project": number;
    "key"?: string;
    "domain"?: string;
    "container": string;
    "language"?: string;
    "controls"?: IEasyGuideMapsEngineOptionsControls;
    "callback"?(oEvent: IEasyGuideMapsEngineMessageResponseFunctionCall): void;
}
interface IEasyGuideMapsEngineOptionsControls {
    "attribution"?: boolean;
    "zoom"?: boolean;
    "rotation"?: boolean;
    "scaleline"?: boolean;
    "fullscreen"?: boolean;
    "layer"?: boolean;
    "route"?: boolean;
}
interface IEasyGuideMapsEngineMessageRequest {
    "message": number;
    "type": string;
    "name": string;
    "arguments": any[];
}
interface IEasyGuideMapsEngineMessageResponseFunctionCall {
    "id": string;
    "message": number;
    "functionName": string;
    "functionArguments": any[];
    "returnValue": any;
}
interface IGuide3DRouteReturnType {
    "distance": number;
    "duration": number;
    "layers": string[];
}
declare class EasyGuideMapsEngine {
    oEasyGuideMapsEngineOptions: IEasyGuideMapsEngineOptions;
    static EVENT_LOADED: string;
    static EVENT_LAYER_CHANGED: string;
    static EVENT_TARGET_SELECTED: string;
    static EVENT_POPUP_ELEMENT_SELECTED: string;
    static EVENT_SCREENSHOT_LOADED: string;
    static EVENT_FUNCTION_RETURN: string;
    static HIGHLIGHT_SET: string;
    static HIGHLIGHT_ADD: string;
    static HIGHLIGHT_REMOVE: string;
    readonly _bDebug: boolean;
    readonly _nProject: number;
    readonly _sLanguage: string;
    private _oVERSION;
    private _sCLASS_NAME;
    private _sRequiredEasyGuideMapsInfo;
    private _sEasyGuideMapsDomain;
    private _oWindowIframe;
    private _fCallback;
    private _oPostMessageResolveFunctionsMap;
    constructor(oEasyGuideMapsEngineOptions: IEasyGuideMapsEngineOptions);
    toString(): string;
    refresh(): Promise<boolean>;
    reset(): Promise<boolean>;
    screenshot(): Promise<boolean>;
    retrieve(sElementType: string): Promise<string[]>;
    retrieveClosestElementsByCoordinates(oLongitudeLatitudeCoordinates: number[], sLayerId: string): Promise<string[]>;
    get(sSettingKey: string): Promise<boolean | number | string>;
    set(sSettingKey: string, sSettingValue: boolean | number | string): Promise<boolean | number | string>;
    route(oWayPointsIdsList: string[], bAccessible?: boolean): Promise<IGuide3DRouteReturnType>;
    focus(sElementId: string, nZoom: number, nAnimationDuration?: number): Promise<boolean>;
    highlight(oElementsToHighlightIdsList: string[], sFillColor: string, sStrokeColor: string, sHighlightMode: string): Promise<string[]>;
    popup(sElementId: string, sHtml: string, bShowCloseButton: boolean): Promise<boolean>;
    private _printDebug(sFunctionName, sDebugDescription);
    private _printWarning(sFunctionName, nWarningCode, sWarningName, sWarningDescription);
    private _printError(sFunctionName, nErrorCode, sErrorName, sErrorDescription);
    private _getUrlEncodedParameters(oParameters);
    private _createFunctionCallMessage(nPostMessageId, sFunctionName, oArguments);
    private _onEvent(oEvent);
}
