
var oEasyGuideMapsEngine;

window.document.addEventListener("DOMContentLoaded", function () {
    "use strict";

    var sStartPointId = "L05P2959";
    var sEndPointId = "L05P2884";

    var oEasyGuideMapsEngineOptions = {
        "debug": false,
        "project": 100101,
        "key": "demo",
        "container": "divMap",
        "controls": {
            "attribution": true,
            "zoom": true,
            "rotation": true,
            "scaleline": true,
            "layer": true,
            "route": true
        },
        "callback": function (oEvent) {
            switch (oEvent.id) {
                case EasyGuideMapsEngine.EVENT_LOADED:
                    console.log(oEvent.info + " loaded");
                    oEasyGuideMapsEngine.set("start", sStartPointId);
                    oEasyGuideMapsEngine.focus(sStartPointId, 0.5, 0);

                    getRouteInfoPromise(sStartPointId, sEndPointId).then(function (oRouteInfo) {

                        console.log("Route-Info: " + oRouteInfo.start + " == " + Math.round(oRouteInfo.distance) + "m" + " / " + Math.round(oRouteInfo.duration) + "s" + " ==> " + oRouteInfo.redirectedEnd + " (redirected from " + oRouteInfo.requestedEnd + ")");                    

                    });

                    break;
                case EasyGuideMapsEngine.EVENT_LAYER_CHANGED:
                    break;
                case EasyGuideMapsEngine.EVENT_POPUP_ELEMENT_SELECTED:
                    break;
                case EasyGuideMapsEngine.EVENT_TARGET_SELECTED:
                    break;
                case EasyGuideMapsEngine.EVENT_FUNCTION_RETURN:
                    break;
                default:
            }
        }
    };

    oEasyGuideMapsEngine = new EasyGuideMapsEngine(oEasyGuideMapsEngineOptions);

    function getRouteInfoPromise(sStartPointId, sEndPointId) {

        var oRouteInfo = {
            start: sStartPointId,
            requestedEnd: sEndPointId
        };
        var oPromiseRouteInfo = new Promise(function (fOnResolve, fOnReject) {
            oEasyGuideMapsEngine.route([sStartPointId, sEndPointId], false).then(function (oRoute) {
                oRouteInfo.distance = oRoute.distance;
                oRouteInfo.duration = oRoute.duration;
                oEasyGuideMapsEngine.get("end").then(function (sRedirectedEndPointId) {
                    oRouteInfo.redirectedEnd = sRedirectedEndPointId;
                    oEasyGuideMapsEngine.route(null).then(function () {
                        fOnResolve(oRouteInfo);
                    });
                });
            }).catch(function (oError) {
                fOnReject(oError);
            });
        });

        return oPromiseRouteInfo;
    }


});